/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于加载及生成本地数据xml文件
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.17
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_ui_box */
/* global mc_sdk_param */
/* global mc_sdk_module */

/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    解析ui_box生成xml文件或解析已知信息生成xml文件
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.6.3
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_ui_box() {
    // 为了更好的分开页面与底层,区分为页面数据,与底层数据 底层数据直接关于文件生成  页面数据不参与生成文件 但根据页面数据产生一些底层数据
    // 底层数据
    // 常规参数运行参数
    var m_obj_param = new mc_sdk_param();
    // 常规参数运行结果
    var m_obj_resul = new mc_sdk_param();
    // 显示芯片寄存器项
    var m_obj_disp_reg = new mc_sdk_param();
    // 显示芯片寄存器列表
    var m_obj_disp_reg_list = new mc_sdk_param();
    // 行管芯片寄存器项
    var m_obj_scan_reg = new mc_sdk_param();
    // 行管芯片寄存器列表
    var m_obj_scan_reg_list = new mc_sdk_param();

    var m_obj_gamma_hw = {};
    var m_arr_gamma_val = [];
    // 接收卡数据
    var m_obj_device_data = new mc_sdk_param();
    // 模组列表
    var m_ary_mod_list = [];

    // 页面交互
    // 箱体页面数据
    var m_obj_ui_box_msg = -1;
    // 箱体宽度
    var m_ui_box_w = -1;
    // 箱体高度
    var m_ui_box_h = -1;
    // 矫正色域控制参数
    var m_obj_correct_msg = {};
    // 亮度
    var m_str_restore = "";
    // 箱体变换信息 [镜像,旋转,缩放,工作模式,裁剪]
    var m_ary_box_trans = ["0", "0,0,0", "0.0,0.0,1.0,1.0", "0","0,0,0,0"];
    // 箱体是否改动标识 ture/false 改动/未改动
    var m_b_box_change = true;
    // 是否为存入箱体 true/false 存入/非存入
    var m_b_is_set = false;


    /* ******************************************* API *********************************************** */

    /**
* 设置箱体为存入箱体
* @returns {boolean} 设置结果
*/
    this.mc_util_set_box_is_set = function () {
        m_b_is_set = true;
        m_b_box_change = false;

        return true;
    };
    /**
* 获取箱体是否为存入箱体
* @returns {boolean} 设置结果
*/
    this.mc_util_get_box_is_set = function () {
        return m_b_is_set;
    };

    /**
* 当前箱体若发送了预存则表示已确定则设置为未改动模式
*/
    this.mc_util_set_box_change = function () {
        m_b_box_change = false;

        return;
    };
    /**
* 获取箱体是否变动标识
* @returns {Boolean} 箱体是否改动标识
*/
    this.mc_util_get_box_change = function () {
        return m_b_box_change;
    };
    /**
* 获取箱体变换信息
* @returns {Array} 箱体变换信息
*/
    this.mc_util_get_trans = function () {
        return m_ary_box_trans;
    };
    /**
* 存入箱体变换信息
* @param {Array} ary_trans 箱体变换信息
*/
    this.mc_util_set_trans = function (ary_trans) {
        m_b_box_change = true;
        this.mc_util_reset(9);
        m_ary_box_trans = ary_trans;
    };

    /**
* @param {Object} obj_gamma_hw 硬件gamma表
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_gamma_hw = function (obj_gamma_hw) {
        if (
            0 >= obj_gamma_hw.type.length ||
            0 >= obj_gamma_hw.data.length
        ) {
            return false;
        }
        m_obj_gamma_hw = obj_gamma_hw;
        return true;
    };
    /**
* @returns {Promise<Object>} 硬件gamma表
*/
    this.mc_util_get_gamma_hw = function () {
        return m_obj_gamma_hw;
    };
    /**
* @param {Array} arr_gamma gamma数据
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_gamma_val = function (arr_gamma) {
        /*     for (var key in arr_gamma) {
                if (!arr_gamma[key]) {
                    return false;
                }
            } */
        m_arr_gamma_val = arr_gamma;
        return true;
    };
    /**
* @returns {Promise<Object>} gamma列表
*/
    this.mc_util_get_gamma_val = function () {
        return m_arr_gamma_val;
    };
    /**
/**
* @param {Object} obj_sdk_param 常规参数
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_param = function (obj_sdk_param) {
        if ("function" !== typeof obj_sdk_param.set_param_value) {
            return false;
        }
        m_b_box_change = true;
        this.mc_util_reset(9);
        m_obj_param = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 常规参数param实例对象
*/
    this.mc_util_get_param = function () {
        return m_obj_param;
    };
    /**
* @param {Object} obj_sdk_param 运行结果
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_resul = function (obj_sdk_param) {
        if ("function" !== typeof obj_sdk_param.set_param_value) {
            return false;
        }
        m_obj_resul = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 运行结果param实例对象
*/
    this.mc_util_get_resul = function () {
        return m_obj_resul;
    };
    /**
* @param {Object} obj_sdk_param 显示芯片寄存器项param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_disp_reg = function (obj_sdk_param) {
        if ("function" !== typeof obj_sdk_param.set_param_value) {
            return false;
        }
        m_b_box_change = true;
        this.mc_util_reset(9);
        m_obj_disp_reg = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 显示芯片寄存器项param实例对象
*/
    this.mc_util_get_disp_reg = function () {
        return m_obj_disp_reg;
    };
    /**
* @param {Object} obj_sdk_param 显示芯片寄存器列表param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_disp_reg_list = function (obj_sdk_param) {
        if ("function" !== typeof obj_sdk_param.set_param_value) {
            return false;
        }
        m_b_box_change = true;
        this.mc_util_reset(9);
        m_obj_disp_reg_list = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 显示芯片寄存器列表param实例对象
*/
    this.mc_util_get_disp_reg_list = function () {
        return m_obj_disp_reg_list;
    };
    /**
* @param {Object} obj_sdk_param 行管芯片寄存器项param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_scan_reg = function (obj_sdk_param) {
        if ("function" !== typeof obj_sdk_param.set_param_value) {
            return false;
        }
        m_b_box_change = true;
        this.mc_util_reset(9);
        m_obj_scan_reg = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 行管芯片寄存器项param实例对象
*/
    this.mc_util_get_scan_reg = function () {
        return m_obj_scan_reg;
    };
    /**
* @param {Object} obj_sdk_param 行管芯片寄存器列表param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_scan_reg_list = function (obj_sdk_param) {
        if ("function" !== typeof obj_sdk_param.set_param_value) {
            return false;
        }
        m_b_box_change = true;
        this.mc_util_reset(9);
        m_obj_scan_reg_list = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 行管芯片寄存器列表param实例对象
*/
    this.mc_util_get_scan_reg_list = function () {
        return m_obj_scan_reg_list;
    };
    /**
* @returns {Promise<Number>} 已知模组数量
*/
    this.mc_util_get_mod_cnt = function () {
        return m_ary_mod_list.length;
    };
    /**
* @param {Number} ui_mod_idx 模组下标
* @returns {Promise<Number>} 对应下标下的模组名称
*/
    this.mc_util_get_mod_name_by_idx = function (ui_mod_idx) {
        if (0 > ui_mod_idx || ui_mod_idx >= m_ary_mod_list.length) {
            return false;
        }
        return m_ary_mod_list[ui_mod_idx].module_name;
    };
    /**
* @param {Array} str_mod_name 模组名称
* @returns {Promise<Object>} 对应名称下的模组mc_sdk_module实例对象
*/
    this.mc_util_get_mod_data_by_name = function (str_mod_name) {
        if ("string" !== typeof str_mod_name || 0 >= str_mod_name.length) {
            return false;
        }

        return mc_get_mod_data_in_name(str_mod_name);
    };
    /**
* @param {String} str_mod_name 模组名称
* @param {Object} obj_sdk_module 模组信息
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_mod = function (str_mod_name, obj_sdk_module) {
        if ("string" !== typeof str_mod_name || 0 >= str_mod_name.length) {
            return false;
        }
        if ("function" !== typeof obj_sdk_module.mc_util_mod_get_xml) {
            return false;
        }
        for (var idx_mod = 0; idx_mod < m_ary_mod_list.length; idx_mod++) {
            if (m_ary_mod_list[idx_mod].module_name === str_mod_name) {
                m_ary_mod_list[idx_mod].module_value = obj_sdk_module;
                return true;
            }
        }
        m_ary_mod_list.push({
            module_name: str_mod_name,
            module_value: obj_sdk_module
        });
        return true;
    };
    /**
* @param {string} obj_sdk_param 接收卡数据
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_device_data = function (obj_sdk_param) {
        if ("function" !== typeof obj_sdk_param.set_param_value) {
            return false;
        }
        m_obj_device_data = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 接收卡数据
*/
    this.mc_util_get_device_data = function () {
        return m_obj_device_data;
    };
    /**
* @param {Number} ui_version_idx 版本号
* @returns {Promise<string>} 根据版本号获取对应ui_box_xml字串
*/
    this.mc_get_ui_box_xml_by_version = function (ui_version_idx) {
        try {
            return mc_get_xml_by_version(ui_version_idx);
        } catch (error) {
            return 5;
        }
    };
    /**
* @param {String} str_box_xml ui_box识别字串
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_box_xml = function (str_box_xml) {
        try {
            return mc_set_box_xml(str_box_xml);
        } catch (error) {
            return 5;
        }
    };
    /**
* 重置
* @param {Number} ui_reset_type 重置标识
* 为空则重置所有,
* 0 - 重置常规参数 ,
* 1 - 重置常规参数返回结果 ,
* 2 - 显示芯片寄存器项 ,
* 3 - 重置显示芯片寄存器列表
* 4 - 重置行管芯片寄存器 ,
* 5 - 重置行管芯片寄存器列表,
* 6 - 重置箱体链接信息,
* 7 - 重置模组列表,
* 8 - 重置gamma,
* 9 - 重置接收卡数据
* 10- 重置矫正色域控制
* 11- 重置亮度
* @returns {Promise<Boolean>} 重置结果
*/
    this.mc_util_reset = function (ui_reset_type) {
        var obj_rest = {
            0: function () {
                m_obj_param = new mc_sdk_param();
            },
            1: function () {
                m_obj_resul = new mc_sdk_param();
            },
            2: function () {
                m_obj_disp_reg = new mc_sdk_param();
            },
            3: function () {
                m_obj_disp_reg_list = new mc_sdk_param();
            },
            4: function () {
                m_obj_scan_reg = new mc_sdk_param();
            },
            5: function () {
                m_obj_scan_reg_list = new mc_sdk_param();
            },
            6: function () {
                m_obj_ui_box_msg = {};
            },
            7: function () {
                m_ary_mod_list = [];
            },
            8: function () {
                m_arr_gamma_val = [];
            },
            9: function () {
                m_obj_device_data = new mc_sdk_param();
            },
            10: function () {
                m_obj_correct_msg = {};
            },
            11: function () {
                m_str_restore = "";
            }
        };

        if (ui_reset_type && obj_rest[ui_reset_type]) {
            obj_rest[ui_reset_type]();
        } else {
            m_obj_param = new mc_sdk_param();
            m_obj_resul = new mc_sdk_param();
            m_obj_disp_reg = new mc_sdk_param();
            m_obj_disp_reg_list = new mc_sdk_param();
            m_obj_scan_reg = new mc_sdk_param();
            m_obj_scan_reg_list = new mc_sdk_param();
            m_obj_gamma_hw = {};
            m_arr_gamma_val = [];
            m_obj_ui_box_msg = -1;
            m_obj_device_data = new mc_sdk_param();
            m_ary_mod_list = [];
            m_obj_correct_msg = {};
            m_str_restore = "";
            m_ary_box_trans = [];
        }
        return true;
    };

    /**
* 存入箱体信息(页面识别参数)
* @param {Object} obj_box_msg 箱体页面数据
*/
    this.mc_util_set_ui_box_msg = function (obj_box_msg) {
        m_b_box_change = true;
        this.mc_util_reset(9);
        // 存入箱体页面数据
        m_obj_ui_box_msg = obj_box_msg;
    };

    /**
* 存入箱体宽高
* @param {Promise<Number>} ui_box_w 箱体宽度
* @param {Promise<Number>} ui_box_h 箱体高度
*/
    this.mc_util_set_box_size = function (ui_box_w, ui_box_h) {
        m_ui_box_w = ui_box_w;
        m_ui_box_h = ui_box_h;
    };
    /**
* 获取箱体宽高
* @returns {Promise<Array>} [ui_box_w , ui_box_h] 箱体宽度 箱体高度
*/
    this.mc_util_get_box_size = function () {
        return [m_ui_box_w, m_ui_box_h];
    };
    /**
* 获取箱体信息(页面识别参数)
* @returns {Object} 箱体信息(页面识别参数)
*/
    this.mc_util_get_ui_box_msg = function () {
        return m_obj_ui_box_msg;
    };
    /**
* 获取箱体中最小jx下第一个模组的名称
* @returns {Object} 箱体中最小jx下第一个模组的名称
*/
    this.mc_util_get_box_first_mod_name = function () {
        return mc_get_box_first_mod_name();
    };

    /**
* 存入矫正页面数据
* @param {Promise<Object>} obj_correct_msg 矫正页面数据
* @returns {Promise<Boolean>} 存入结果
*/
    this.mc_util_set_correct_msg = function (obj_correct_msg) {
        if (
            !Array.isArray(obj_correct_msg.arr_tbl_data) ||
            9 > obj_correct_msg.arr_tbl_data.length ||
            "boolean" !== typeof obj_correct_msg.b_gamut_switch
        ) {
            return false;
        }
        m_obj_correct_msg = obj_correct_msg;
        return true;
    };
    /**
* 获取矫正页面数据
* @returns {Promise<Object>} 矫正页面数据
*/
    this.mc_util_get_correct_msg = function () {
        return m_obj_correct_msg;
    };
    /**
* 存入显示控制页面参数
* @param {Promise<String>} str_restore 显示控制页面参数
* @returns {Promise<Boolean>} 存入结果
*/
    this.mc_util_set_restore = function (str_restore) {
        if (
            "string" !== typeof str_restore ||
            -1 === str_restore.indexOf(":") ||
            3 !== str_restore.split(":").length
        ) {
            return false;
        }

        m_str_restore = str_restore;
        return true;
    };
    /**
* 获取显示控制页面参数
* @returns {Promise<String>} 显示控制页面参数
*/
    this.mc_util_get_restore = function () {
        return m_str_restore;
    };

    /* ******************************************* TOOL ******************************************** */
    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    分析版本根据不同版本文件解析字串,获取对应参数
* 参数:
*     @param {Promise<String>} str_box_xml ui_box识别字串
* 返回：
*    @returns {Promise<Boolean>} 储存结果
* 备注:
* 错误返回:
*      0:参数错误
*      1:芯片错误
*      2:分组模式错误
*      3:引脚错误
*      4:三线并行颜色错误
*      5:其他错误
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.6.3
*      内容 : 所有代码
************************************************************************************************/
    function mc_set_box_xml(str_box_xml) {
        if ("string" !== typeof str_box_xml || 0 >= str_box_xml.length) {
            return 0;
        }
        // 解析对象
        var obj_vesion_data = {};
        var obj_box_data = new mc_box_data();

        // 第一版本解析
        if (obj_box_data.set_xml_text(str_box_xml)) {
            obj_box_data = obj_box_data.query_object("box");
            obj_vesion_data = new mc_box_version_1();

            if (!obj_vesion_data.mc_util_analysis_box(obj_box_data)) {
                return 5;
            }
            m_obj_param = obj_vesion_data.mc_util_get_param();
            m_obj_resul = obj_vesion_data.mc_util_get_resul();
            m_obj_disp_reg = obj_vesion_data.mc_util_get_disp_reg();
            m_obj_disp_reg_list = obj_vesion_data.mc_util_get_disp_reg_list();
            m_obj_scan_reg = obj_vesion_data.mc_util_get_scan_reg();
            m_obj_scan_reg_list = obj_vesion_data.mc_util_get_scan_reg_list();
            m_obj_gamma_hw = obj_vesion_data.mc_util_get_gamma_hw();
            m_arr_gamma_val = obj_vesion_data.mc_util_get_gamma_val();
            m_obj_ui_box_msg = obj_vesion_data.mc_util_get_box_msg();
            m_ary_mod_list = obj_vesion_data.mc_util_get_mod_list();
            m_obj_device_data = obj_vesion_data.mc_util_get_device_data();
            m_obj_correct_msg = obj_vesion_data.mc_util_get_correct_msg();
            m_str_restore = obj_vesion_data.mc_util_get_restore();
            m_ary_box_trans = obj_vesion_data.mc_util_get_box_trans();
            var ui_check_error = mc_check_box();

            return 0 === ui_check_error ? true : ui_check_error;
        }
        return 0;
    }
    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    根据版本号,获取对应xml字串
* 参数:
*     @param {Number} ui_version_idx 版本号
* 返回：
*    @returns {Promise<string>} 对应版本号xml字串
* 备注:
* 错误返回:
*      0:参数错误
*      1:芯片错误
*      2:分组模式错误
*      3:引脚错误
*      4:三线并行颜色错误
*      5:其他错误
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.6.3
*      内容 : 所有代码
************************************************************************************************/
    function mc_get_xml_by_version(ui_version_idx) {
        var obj_version_xml = -1;

        var ui_check_error = mc_check_box();

        if (0 !== ui_check_error) {
            return ui_check_error;
        }
        switch (ui_version_idx) {
        case 1:
            obj_version_xml = new mc_box_version_1();
            break;
        default:
            return 0;
        }
        obj_version_xml.mc_util_set_param(m_obj_param);
        obj_version_xml.mc_util_set_resul(m_obj_resul);
        obj_version_xml.mc_util_set_disp_reg(m_obj_disp_reg);
        obj_version_xml.mc_util_set_disp_reg_list(m_obj_disp_reg_list);
        obj_version_xml.mc_util_set_scan_reg(m_obj_scan_reg);
        obj_version_xml.mc_util_set_scan_reg_list(m_obj_scan_reg_list);
        obj_version_xml.mc_util_set_gamma_hw(m_obj_gamma_hw);
        obj_version_xml.mc_util_set_gamma_val(m_arr_gamma_val);
        obj_version_xml.mc_util_set_box_msg(m_obj_ui_box_msg, m_ui_box_w, m_ui_box_h);
        obj_version_xml.mc_util_set_mod_list(m_ary_mod_list);
        obj_version_xml.mc_util_set_device_data(m_obj_device_data);
        obj_version_xml.mc_util_set_correct_msg(m_obj_correct_msg);
        obj_version_xml.mc_util_set_restore(m_str_restore);
        obj_version_xml.mc_util_set_box_trans(m_ary_box_trans);
        return obj_version_xml.mc_util_get_box_xml();
    }


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    转换箱体页面交互数据
* 参数:
*    NA
* 返回：
*    @returns {Promise<Number>} 结果
* 备注:
*    0:完成
*    1:芯片错误
*    2:分组模式错误
*    3:引脚错误
*    4:三线并行颜色错误
*    5:其他错误
*    6:行扫数错误
*
* 注意:
*      1.一个箱内的所有芯片，行扫数，数据串类型必需一致（串行不管几灯串还是乱串，都认为是串行）
*      2.至于第一个口是一组数据，第二个口是两组数据，这个不强制，但是你那边可以简单点处理，要求必需一样
*      3.三线并行的，三个线颜色顺序可以不一样，但是一个组串的所有模组，必需一样，这个也一样，你那边可以简单一点处理，要求必需一样
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.10.26
*      内容 : 所有代码
************************************************************************************************/
    function mc_check_box() {
        // 所有模组列表数据
        var ary_module_list = m_obj_ui_box_msg.data;
        // 箱体下第一个模组数据
        var obj_first_mod_data = mc_get_mod_data_in_name(mc_get_box_first_mod_name()).module_value;
        var str_dispchip_name = obj_first_mod_data.mc_util_mod_get_disp_chip();
        var str_scanchip_name = obj_first_mod_data.mc_util_mod_get_scan_chip();
        var ui_grp_mod = Number(obj_first_mod_data.mc_util_mod_get_str_grp_mode());
        var ary_color = obj_first_mod_data.mc_util_mod_get_clr_msg();
        var ui_str_cnt = Number(obj_first_mod_data.mc_util_mod_get_str_cnt());
        var ui_scan_cnt = Number(obj_first_mod_data.mc_util_mod_get_max_scan_cnt());


        for (var idx_jx = 0; idx_jx < ary_module_list.length; idx_jx++) {
            var ary_jx_modlist = ary_module_list[idx_jx].children;
            var str_module_name = "";

            for (var idx_mod = 0; idx_mod < ary_jx_modlist.length; idx_mod++) {
                str_module_name = ary_jx_modlist[idx_mod].module_name;

                var obj_sdk_module = mc_get_mod_data_in_name(str_module_name).module_value;
                var str_dispchip_name_use = obj_sdk_module.mc_util_mod_get_disp_chip();
                var str_scanchip_name_use = obj_sdk_module.mc_util_mod_get_scan_chip();
                var ui_grp_mod_use = Number(obj_sdk_module.mc_util_mod_get_str_grp_mode());
                var ary_color_use = obj_sdk_module.mc_util_mod_get_clr_msg();
                var ui_str_cnt_use = Number(obj_sdk_module.mc_util_mod_get_str_cnt());
                var ui_scan_cnt_use = Number(obj_sdk_module.mc_util_mod_get_max_scan_cnt());

                if (0 === obj_sdk_module) {
                    return 5;
                }
                if (
                    str_dispchip_name_use !== str_dispchip_name ||
                    str_scanchip_name_use !== str_scanchip_name
                ) {
                    return 1;
                }
                if (ui_grp_mod !== ui_grp_mod_use) {
                    return 2;
                }
                if (ui_str_cnt_use !== ui_str_cnt) {
                    return 3;
                }
                if (
                    3 === ui_grp_mod &&
                    mc_use_color_error(ary_color, ary_color_use)
                ) {
                    return 4;
                }
                if (ui_scan_cnt_use !== ui_scan_cnt) {
                    return 6;
                }
            }
        }

        return 0;
    }


    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    获取箱体内第一个模组的名称
* 参数:
*    NA
* 返回：
*    @returns {Promise<String>} 箱体中第一个模组名称
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.10.26
*      内容 : 所有代码
************************************************************************************************/
    function mc_get_box_first_mod_name() {
        // 存入箱体最小jx下第一个模组名称
        // 箱体中的模组列表
        var ary_module_list = m_obj_ui_box_msg.data;
        var str_first_mod_name = ary_module_list[0].children[0].module_name;

        for (var idx_modlist = 1; idx_modlist < ary_module_list.length; idx_modlist++) {
            var obj_modlist_msg = ary_module_list[idx_modlist];
            var obj_modlist_msg_last = ary_module_list[idx_modlist - 1];

            var ui_jx_num = Number(obj_modlist_msg.jx_num);
            var ui_jx_num_last = Number(obj_modlist_msg_last.jx_num);

            // 如果当前jx比上一次的jx小 则第一个模组名称更换为当前jx下第一个模组的名称
            if (ui_jx_num_last > ui_jx_num) {
                str_first_mod_name = ary_module_list[idx_modlist].children[0].module_name;
            }
        }
        return str_first_mod_name;
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    根据模组名称 获取指定模组数据
* 参数:
*    @param {Promise<String>} str_mod_name 模组名称
* 返回：
*    @returns {Promise<Object>} mc_sdk_module实例对象
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.10.26
*      内容 : 所有代码
************************************************************************************************/
    function mc_get_mod_data_in_name(str_mod_name) {
        var obj_mod_data = 0;

        for (var idx_mod = 0; idx_mod < m_ary_mod_list.length; idx_mod++) {
            if (m_ary_mod_list[idx_mod].module_name === str_mod_name) {
                obj_mod_data = m_ary_mod_list[idx_mod];
            }
        }
        return obj_mod_data;
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    检测颜色是否不同
* 参数:
*    @param {Promise<Array>} ary_color 使用颜色
*    @param {Promise<Array>} ary_color_contrast 对比颜色
* 返回：
*    @returns {Promise<Boolean>} 是否不同
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.10.26
*      内容 : 所有代码
************************************************************************************************/
    function mc_use_color_error(ary_color, ary_color_contrast) {
        if (ary_color.length !== ary_color_contrast.length) {
            return true;
        }
        for (var idx_contrast = 0; idx_contrast < ary_color.length; idx_contrast++) {
            if (ary_color[idx_contrast] !== ary_color_contrast[idx_contrast]) {
                return true;
            }
        }
        return false;
    }
}

/* ******************************** TOOL ************************************************ */
function mc_box_data() {
    var box_table = {
        "tagName": "box",
        "attrs": {
            "version": "1.0",
            "chip_type_name": ""
        },
        "children": [{
            "tagName": "basic",
            "attrs": {
                "name": "",
                "w": "",
                "h": "",
                "driveric": "",
                "scanic": "",
                "scan_count": "",
                "data_group_count": "",
                "moudle_count": "",
                "module_name": "",
                "scan_order": ""
            }
        },
        {
            "tagName": "performance",
            "attrs": {}
        },
        {
            "tagName": "result",
            "attrs": {}
        },
        {
            "tagName": "basic_reg"
        },
        {
            "tagName": "advance_reg"
        },
        {
            "tagName": "basic_scan_reg"
        },
        {
            "tagName": "advance_scan_reg"
        },
        {
            "tagName": "gamma",
            "attrs": {
                "gamma_mode": "0"
            }
        },
        {
            "tagName": "gamma_cfg",
            "children": []
        },
        {
            "tagName": "pin",
            "attrs": {
                "name": "",
                "iccount": "1",
                "all_use_dat_pin_count": ""
            }
        },
        {
            "tagName": "module_layout",
            "attrs": {
                "jx_count": "0"
            }
        },
        {
            "tagName": "module_data",
            "attrs": {
                "module_data_count": "0"
            }
        },
        {
            "tagName": "device_data",
            "attrs": {
                "ic_use_count": "0"
            }
        }, {
            "tagName": "restore"
        }, {
            "tagName": "correct"
        }, {
            "tagName": "box_trans",
            "attrs": {
                "mirror": "0",
                "rotation": "0,0,0",
                "scale": "0.0,0.0,1.0,1.0",
                "cut": "0,0,0,0"
            }
        }
        ]
    };

    function get_attributes(element) {
        if (element.attributes.length) {
            var res = {};

            for (var i = 0; i < element.attributes.length; i++) {
                res[element.attributes[i].name] = element.attributes[i].value;
            }
            return res;
        }
        return "";
    }

    function parse_node(element, dst) {
        dst.tagName = element.tagName;
        var attrs = get_attributes(element);

        if (attrs) {
            dst.attrs = attrs;
        }
        var elementNodes = Array.prototype.filter.call(element.childNodes, function (node) {
            return 1 === node.nodeType;
        });
        var textNodes = Array.prototype.filter.call(element.childNodes, function (node) {
            return 3 === node.nodeType;
        });
        var data = (function () {
            var s = "";

            for (var i = 0; i < textNodes.length; i++) {
                s += textNodes[i].textContent;
            }
            return s.trim();
        }());

        if (data.trim().length) {
            dst.data = data;
        }
        if (elementNodes.length) {
            dst.children = [];
        }
        if ("box" === dst.tagName) {
            var ui_add_idx = 0;

            for (var idx_box = 0; idx_box < box_table.children.length; idx_box++) {
                var idx_ele = 0;
                var str_tagname = box_table.children[idx_box].tagName;

                dst.children[idx_box] = {};
                for (idx_ele = 0; idx_ele < elementNodes.length; idx_ele++) {
                    var str_children_tagname = elementNodes[idx_ele].tagName;

                    if (str_children_tagname === str_tagname) {
                        break;
                    }
                }
                if (idx_ele === elementNodes.length) {
                    continue;
                }
                parse_node(elementNodes[idx_ele], dst.children[ui_add_idx]);
                ui_add_idx++;
            }
        } else {
            for (var i = 0; i < elementNodes.length; i++) {
                dst.children[i] = {};
                parse_node(elementNodes[i], dst.children[i]);
            }
        }
    }

    function parse_element(box) {
        var res = {};

        parse_node(box, res);
        if (!Object.prototype.hasOwnProperty.call(res, "tagName")) {
            return box_table;
        }
        for (var i = 0; i < box_table.children.length; i++) {
            if (i >= res.children.length) {
                res.children.push(box_table.children[i]);
            } else if (res.children[i].tagName !== box_table.children[i].tagName) {
                res.children.splice(i, 0, box_table.children[i]);
            }
        }
        return res;
    }

    function start_tag(obj) {
        return "<" + obj.tagName;
    }

    function set_atrribute(obj) {
        var res = "";
        var keys = obj.attrs ? Object.keys(obj.attrs) : [];

        for (var i = 0; i < keys.length; i++) {
            res += " " + keys[i] + "=" + "\"" + obj.attrs[keys[i]] + "\"";
        }
        if (obj.data || obj.children) {
            res += ">";
        }
        return res;
    }

    function set_data_inner_use(obj) {
        return obj.data ? obj.data : "";
    }

    function close_tag(obj) {
        if (obj.data || obj.children) {
            var str_rertrn = "</" + obj.tagName + ">";

            if (obj.children) {
                str_rertrn = "\n" + str_rertrn;
            }
            return str_rertrn;
        }
        return "/>";
    }

    function pack(obj) {
        var s = "\n";

        s += start_tag(obj);
        s += set_atrribute(obj);
        s += set_data_inner_use(obj);
        for (var i = 0; obj.children && i < obj.children.length; i++) {
            s += pack(obj.children[i]);
        }
        s += close_tag(obj);
        return s;
    }

    function get_xml_text(box) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + pack(box);
    }

    function query(obj, tagName) {
        var attrs = attrbutes(tagName);
        var tag = tagName.split("[")[0];
        var i = 0;

        if (obj.tagName === tag) {
            var match = true;

            for (i = 0; i < attrs.length; i++) {
                var key = attrs[i][0];
                var value = attrs[i][1];

                if (value) {
                    if (obj.attrs && obj.attrs[key] !== value) {
                        match = false;
                    }
                } else {
                    if (obj.attrs && !Object.prototype.hasOwnProperty.call(obj.attrs, key)) {
                        match = false;
                    }
                }
            }
            if (match) {
                return obj;
            }
        }
        for (i = 0; obj.children && i < obj.children.length; i++) {
            var obj_tag = query(obj.children[i], tagName);

            if (obj_tag) {
                return obj_tag;
            }
        }
        return {};
    }

    function attrbutes(str) {
        str = str.replace(/\s+/g, "");
        var m = str.match(/\w+\[(.+)\]/);

        if (m) {
            var attrs = m[1].split("and");

            return attrs.map(function (e) {
                var a = e.split("=");

                a[0] = a[0].slice(1);
                return a;
            });
        }
        return [];
    }

    function query_object(root, select) {
        var tags = select.split("/");
        var obj_tmp = root;

        for (var i = 0; i < tags.length; i++) {
            obj_tmp = query(obj_tmp, tags[i]);
            if (!obj_tmp) {
                return {};
            }
        }
        return obj_tmp;
    }

    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取指定的箱体标签
* 参数:
*    @param {promises<string>} select 选择符 / 分隔标签 []里指定属性, @attribute=value格式，and分隔多个属性，格式为a/b[@attr1=value1 and attr2=value2 and attr3]/
* 返回：
*    @returns {promises<boolean>} 操作结果
* 例子：
*    'module_data/str[@pin_id=C2]/item[@x=1 and @y=0]' 返回 一个item标签的Object对象，此对象位于module_data 下str标签之下，
*    其中str的pin_id=2, item的x=1,y=0
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 曹冰星
*      时间 : 2019.10.31
*      内容 : 所有代码
************************************************************************************************/
    this.query_object = function (select) {
        return query_object(box_table, select);
    };
    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    把xml格式数据解析到JSON对象
* 参数:
*    @param {promises<string>} str_xml_text xml格式字符串数据
* 返回：
*   @returns  {promises<string>} true 表示设置成功, false 设置失败,使用默认值
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 曹冰星
*      时间 : 2019.10.31
*      内容 : 所有代码
************************************************************************************************/
    this.set_xml_text = function (str_xml_text) {
        var parser = new DOMParser();
        var doc = parser.parseFromString(str_xml_text, "text/xml");
        var box = doc.getElementsByTagName("box")[0];

        if (!box) {
            return false;
        }
        var old_table = box_table;

        box_table = parse_element(box);
        if (old_table === box_table) {
            return false;
        }
        return true;
    };

    /************************************************************************************************
* 类型:
*    函数
* 功能:
*    对象转换为xml格式数据
* 参数:
*    NA
* 返回：
*    @returns {promises<boolean>} xml格式数据
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 曹冰星
*      时间 : 2019.10.31
*      内容 : 所有代码
************************************************************************************************/
    this.get_xml_text = function () {
        return get_xml_text(box_table);
    };
}

/************************************************************************************************
 * 类型:
 *    功能函数
 * 功能:
 *    字符串截取
 * 参数:
 *    @param {promises<string>} str_dispose_val 需要处理的字串
 *    @param {promises<string>} str_dispose_way 需要处理方式
 * 返回：
 *    @returns {Promise<Array>} 截取后的数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.6.3
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_uibox_splice_str(str_dispose_val, str_dispose_way) {
    if ("string" !== typeof str_dispose_val || 0 >= str_dispose_val.length) {
        return [];
    }
    if ("string" !== typeof str_dispose_way || 0 >= str_dispose_way.length) {
        return [];
    }
    if (-1 === str_dispose_val.indexOf(str_dispose_way)) {
        return [str_dispose_val];
    }
    return str_dispose_val.split(str_dispose_way);
}


/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    box_xml文件1.0版本分析函数,及生成函数
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.6.3
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_box_version_1() {
    var m_obj_box_data = {};
    var m_obj_param = new mc_sdk_param();
    var m_obj_resul = new mc_sdk_param();
    var m_obj_disp_reg = new mc_sdk_param();
    var m_obj_disp_reg_list = new mc_sdk_param();
    var m_obj_scan_reg = new mc_sdk_param();
    var m_obj_scan_reg_list = new mc_sdk_param();
    var m_obj_gamma = {};
    var m_obj_gamma_cfg = {};
    var m_obj_box = {};
    var m_ui_box_w = 0;
    var m_ui_box_h = 0;
    var m_ary_mod_list = [];
    var m_obj_device_data = new mc_sdk_param();
    var m_obj_correct_msg = {
        arr_tbl_data: ["1.0000", "0.0000", "0.0000", "0.0000", "1.0000", "0.0000", "0.0000", "0.0000", "1.0000"],
        b_gamut_switch: false
    };
    var m_str_restore = "(100:100:100)";

    var m_ary_box_trans = ["0", "0,0,0", "0.0,0.0,1.0,1.0", "0","0,0,0,0"];

    var BASIC = 0;
    var PERFORMANCE = 1;
    var RESULT = 2;
    var BASIC_REG = 3;
    var ADVANCE_REG = 4;
    var BASIC_SCAN_REG = 5;
    var ADVANCE_SCAN_REG = 6;
    var GAMMA = 7;
    var GAMMA_CFG = 8;
    var PIN = 9;
    var MODULE_LAYOUT = 10;
    var MODULE_DATA = 11;
    var DEVICE_DATA = 12;
    var RESTORE = 13;
    var CORRECT = 14;
    var TRANS = 15;


    // 性能参数翻译表
    var obj_lang_pamar = {
        "data_level_duty_ratio": "DATA_LEVEL_RATIO",
        "data_level_freq_mhz": "DATA_LEVEL_FREQ",
        "data_level_offset": "DATA_LEVEL_OFFSET",
        "gray_level_duty_ratio": "GRAY_LEVEL_RATIO",
        "gray_level_freq_mhz": "GRAY_LEVEL_FREQ",
        "gray_bit_size": "GRAY_BIT_SIZE",
        "input_gray_bit_size": "INPUT_BIT_WIDTH",
        "frame_refresh_freq": "FRME_REFRESH_FREQ",
        "scan_row_refresh_freq": "SCAN_REFRESH_FREQ",
        "scan_change_ns": "SCAN_CHANGE_TIME",
        "scan_change_offset_ns": "SCAN_CHANGE_OFFSET_TIME",
        "min_oe_ns": "MIN_OE_TIME",
        "close_ns": "CLOSE_TIME",
        "freq_ups": "FREQ_UPS",
        "disp_mode": "DISP_MODE",
        "rectify_mode": "RECTIFY_MODE",
        "frme_head_wait": "FRME_HEAD_WAIT",
        "frme_tail_wait": "FRME_TAIL_WAIT",
        "low_delay_mode": "LOW_DELAY_MODE",
        "offline_mode": "OFFLINE_MODE",
        "img_width": "IMG_WIDTH",
        "img_height": "IMG_HEIGHT",
        "img_offset_x": "IMG_OFFSET_X",
        "img_offset_y": "IMG_OFFSET_Y",
        "pix_input_bit_size": "PIX_INPUT_BIT_SIZE",
        "pix_output_bit_size": "PIX_OUTPUT_BIT_SIZE",
        "bright_percent_r": "BRIGHT_PERCENT_R",
        "bright_percent_g": "BRIGHT_PERCENT_G",
        "bright_percent_b": "BRIGHT_PERCENT_B",
        "abc_delay": "ABC_DELAY",
        "gama_max_val": "GAMA_MAX_VAL",
        "gama_factor": "GAMA_FACTOR"
    };
    var obj_lang_result = {
        "data_level_duty_ratio": "DATA_LEVEL_RATIO",
        "data_level_offset": "DATA_LEVEL_OFFSET",
        "gray_level_duty_ratio": "GRAY_LEVEL_RATIO",
        "reg_cfg_time": "REG_CFG_TIME",
        "frame_head_wait_ns": "FRME_HEAD_WAIT",
        "frame_tail_wait_ns": "FRME_TAIL_WAIT",
        "scan_change_ns": "SCAN_CHANGE_TIME",
        "scan_change_offset_ns": "SCAN_CHANGE_OFFSET_TIME",
        "min_oe_ns": "MIN_OE_TIME",
        "close_ns": "CLOSE_TIME",
        "row_refresh_freq": "ROW_FREQ",
        "brightness_effective": "LUMI_EFFICT",
        "ic_reg_bit_size": "REG_BIT_SIZE",
        "refresh_freq_list_count": "SCAN_REFRESH_LIST",
        "freq_ups_value": "FREP_UPS",
        "freq_ups_item_count": "ENABLED_FREQ_UPS_ARY",
        "disp_mode_ary_value": "DISP_MODE",
        "disp_mode_ary_item_count": "ENABLED_DISP_MODE_ARY",
        "box_file": "BOX_FILE",
        "enable_mod_asyn": "ENABLE_MOD_ASYN",
        "data_level_freq": "DATA_LEVEL_FREQ",
        "gray_bit_size": "GRAY_BIT_SIZE",
        "gray_level_freq": "GRAY_LEVEL_FREQ",
        "frme_refresh_freq": "FRME_REFRESH_FREQ",
        "frme_head_wait": "FRME_HEAD_WAIT",
        "rectify_mode": "RECTIFY_MODE",
        "offline_mode": "OFFLINE_MODE",
        "img_width": "IMG_WIDTH",
        "img_height": "IMG_HEIGHT",
        "pix_input_bit_size": "PIX_INPUT_BIT_SIZE",
        "pix_output_bit_size": "PIX_OUTPUT_BIT_SIZE",
        "freq_ups": "FREQ_UPS",
        "bright_percent_r": "BRIGHT_PERCENT_R",
        "bright_percent_g": "BRIGHT_PERCENT_G",
        "bright_percent_b": "BRIGHT_PERCENT_B",
        "abc_delay": "ABC_DELAY",
        "gama_max_val": "GAMA_MAX_VAL",
        "gama_factor": "GAMA_FACTOR"
    };

    /* ******************************** AIP ******************************************************** */
    /**
* 存入箱体变换信息
* @param {Promise<Array>} ary_box_trans 箱体变换信息
*/
    this.mc_util_set_box_trans = function (ary_box_trans) {
        m_ary_box_trans = ary_box_trans;
    };

    /**
* 获取箱体变换信息
* @returns {Promise<Array>} 箱体变换信息
*/
    this.mc_util_get_box_trans = function () {
        return m_ary_box_trans;
    };
    /**
* 存入矫正页面数据
* @param {Promise<Object>} obj_correct_msg 矫正页面数据
* @returns {Promise<Boolean>} 存入结果
*/
    this.mc_util_set_correct_msg = function (obj_correct_msg) {
        if (
            !Array.isArray(obj_correct_msg.arr_tbl_data) ||
            9 > obj_correct_msg.arr_tbl_data.length ||
            "boolean" !== typeof obj_correct_msg.b_gamut_switch
        ) {
            return false;
        }
        m_obj_correct_msg = obj_correct_msg;
        return true;
    };
    /**
* 获取矫正页面数据
* @returns {Promise<Object>} 矫正页面数据
*/
    this.mc_util_get_correct_msg = function () {
        return m_obj_correct_msg;
    };
    /**
* 存入显示控制页面参数
* @param {Promise<String>} str_restore 显示控制页面参数
* @returns {Promise<Boolean>} 存入结果
*/
    this.mc_util_set_restore = function (str_restore) {
        if (
            "string" !== typeof str_restore ||
            -1 === str_restore.indexOf(":") ||
            3 !== str_restore.split(":").length
        ) {
            return false;
        }

        m_str_restore = str_restore;
        return true;
    };
    /**
* 获取显示控制页面参数
* @returns {Promise<String>} 显示控制页面参数
*/
    this.mc_util_get_restore = function () {
        return m_str_restore;
    };
    /**
* @param {Object} obj_box_data 已经解析好的box对象
* @returns {Promise<Boolean>} 解析结果
*/
    this.mc_util_analysis_box = function (obj_box_data) {
        m_obj_box_data = obj_box_data;

        if (!mc_anlysis_box()) {
            return false;
        }
        return true;
    };
    /**
* @param {Object} obj_sdk_param 常规参数param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_param = function (obj_sdk_param) {
        if (!obj_sdk_param.get_param_cnt()) {
            return false;
        }
        m_obj_param = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 常规参数param实例对象
*/
    this.mc_util_get_param = function () {
        return m_obj_param;
    };
    /**
* @param {Object} obj_sdk_resul 运行结果param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_resul = function (obj_sdk_resul) {
        if (!obj_sdk_resul.get_param_cnt()) {
            return false;
        }
        m_obj_resul = obj_sdk_resul;
        return true;
    };
    /**
* @returns {Promise<Object>} 运行结果param实例对象
*/
    this.mc_util_get_resul = function () {
        return m_obj_resul;
    };
    /**
* @param {Object} obj_sdk_param 显示芯片寄存器项param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_disp_reg = function (obj_sdk_param) {
        if (!obj_sdk_param.get_param_cnt()) {
            return false;
        }
        m_obj_disp_reg = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 显示芯片寄存器项param实例对象
*/
    this.mc_util_get_disp_reg = function () {
        return m_obj_disp_reg;
    };
    /**
* @param {Object} obj_sdk_param 显示芯片寄存器列表param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_disp_reg_list = function (obj_sdk_param) {
        if (!obj_sdk_param.get_param_cnt()) {
            return false;
        }
        m_obj_disp_reg_list = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 显示芯片寄存器列表param实例对象
*/
    this.mc_util_get_disp_reg_list = function () {
        return m_obj_disp_reg_list;
    };
    /**
* @param {Object} obj_sdk_param 行管芯片寄存器项param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_scan_reg = function (obj_sdk_param) {
        if (!obj_sdk_param.get_param_cnt()) {
            return false;
        }
        m_obj_scan_reg = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 行管芯片寄存器项param实例对象
*/
    this.mc_util_get_scan_reg = function () {
        return m_obj_scan_reg;
    };
    /**
* @param {Object} obj_sdk_param 行管芯片寄存器列表param实例对象
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_scan_reg_list = function (obj_sdk_param) {
        if (!obj_sdk_param.get_param_cnt()) {
            return false;
        }
        m_obj_scan_reg_list = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 行管芯片寄存器列表param实例对象
*/
    this.mc_util_get_scan_reg_list = function () {
        return m_obj_scan_reg_list;
    };
    /**
* @param {Object} obj_gamma_hw 下发硬件gama表
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_gamma_hw = function (obj_gamma_hw) {
        if (!obj_gamma_hw.type || !obj_gamma_hw.data) {
            return false;
        }
        m_obj_gamma = obj_gamma_hw;
        return true;
    };
    /**
* @returns {Promise<Object>} gamma表硬件信息
*/
    this.mc_util_get_gamma_hw = function () {
        return m_obj_gamma;
    };
    /**
* @param {Array} arr_gamma_date gamma表页面数据
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_gamma_val = function (arr_gamma_date) {
        if (!Array.isArray(arr_gamma_date) || 0 === arr_gamma_date.length) {
            return false;
        }

        if (1 === arr_gamma_date.length) {
            m_obj_gamma_cfg = arr_gamma_date[0];
        }
        /*         for (var gamma_idx = 0; gamma_idx < arr_gamma_date.length; gamma_idx++) {
m_obj_gamma_cfg = arr_gamma_date[gamma_idx];
} */
        return true;
    };
    /**
* @returns {Promise<Array>} gamma表页面数据
*/
    this.mc_util_get_gamma_val = function () {
        return m_obj_gamma_cfg;
    };
    /**
* @param {Object} obj_box_msg 箱体信息
* @param {Number} ui_box_w 箱体宽度
* @param {Number} ui_box_h 箱体高度
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_box_msg = function (obj_box_msg, ui_box_w, ui_box_h) {
        m_obj_box = obj_box_msg;
        m_ui_box_w = ui_box_w;
        m_ui_box_h = ui_box_h;
        return true;
    };
    /**
* @returns {Promise<Object>} 箱体信息recvcard实例对象
*/
    this.mc_util_get_box_msg = function () {
        return m_obj_box;
    };
    /**
* @param {Array} ary_mod_list 模组数据
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_mod_list = function (ary_mod_list) {
        if (0 >= ary_mod_list) {
            return false;
        }
        m_ary_mod_list = ary_mod_list;
        return true;
    };
    /**
* @returns {Promise<Array>} 模组数据
*/
    this.mc_util_get_mod_list = function () {
        return m_ary_mod_list;
    };
    /**
* @param {Object} obj_sdk_param 接收卡数据
* @returns {Promise<Boolean>} 储存结果
*/
    this.mc_util_set_device_data = function (obj_sdk_param) {
        if (!obj_sdk_param.get_param_cnt()) {
            return false;
        }
        m_obj_device_data = obj_sdk_param;
        return true;
    };
    /**
* @returns {Promise<Object>} 接收卡数据
*/
    this.mc_util_get_device_data = function () {
        return m_obj_device_data;
    };
    /**
* @returns {Promise<String>} ui_box识别xml字串
*/
    this.mc_util_get_box_xml = function () {
        return mc_get_box_xml();
    };


    /* ******************************** TOOL ******************************************************** */

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    解析已知数据,生成箱体信息
* 参数:
*    NA
* 返回：
*    @returns {Promise<Boolean>} 解析结果
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.6.3
*      内容 : 所有代码
************************************************************************************************/
    function mc_anlysis_box() {
        //
        if (
            !mc_uibox_trans_recvcard_from_local() ||
            !mc_uibox_trans_performance_from_local() ||
            !mc_uibox_trans_result_from_local()
        ) {
            return false;
        }
        mc_uibox_trans_device_data();
        mc_uibox_trans_ui_msg();
        m_obj_disp_reg.set_json(m_obj_box_data.children[BASIC_REG].data);
        m_obj_disp_reg_list.set_json(m_obj_box_data.children[ADVANCE_REG].data);
        m_obj_scan_reg.set_json(m_obj_box_data.children[BASIC_SCAN_REG].data);
        m_obj_scan_reg_list.set_json(m_obj_box_data.children[ADVANCE_SCAN_REG].data);
        var ary_gama_data = mc_uibox_trans_gamma();

        m_obj_gamma = ary_gama_data[0];
        m_obj_gamma_cfg = ary_gama_data[1];
        var ui_mod_cnt = m_obj_box_data.children[MODULE_DATA].children.length;

        for (var idx_mod = 0; idx_mod < ui_mod_cnt; idx_mod++) {
            mc_uibox_trans_module_from_local(idx_mod);
        }

        mc_data_check();
        return true;
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    解析导入箱体数据
* 参数:
*    NA
* 返回：
*   @returns {Promise<Boolean>} 执行是否成功结果
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.6.3
*      内容 : 所有代码
************************************************************************************************/
    function mc_uibox_trans_recvcard_from_local() {
        var obj_box_trans = m_obj_box_data.children[TRANS];

        if (!obj_box_trans.attrs.workmode || "undefined" === obj_box_trans.attrs.workmode.toLocaleLowerCase()) {
            obj_box_trans.attrs.workmode = "0";
        }
        if (!obj_box_trans.attrs.cut || "undefined" === obj_box_trans.attrs.cut.toLocaleLowerCase()) {
            obj_box_trans.attrs.cut = "0,0,0,0";
        }

        m_ary_box_trans = [
            obj_box_trans.attrs.mirror,
            obj_box_trans.attrs.rotation,
            obj_box_trans.attrs.scale,
            obj_box_trans.attrs.workmode,
            obj_box_trans.attrs.cut
        ];
        // pin 标签
        var obj_pin = m_obj_box_data.children[PIN];

        // 存入芯片名称
        m_obj_box.ctrlchip_name = m_obj_box_data.attrs.chip_type_name;
        m_obj_box.hub_name = obj_pin.attrs.name;

        var obj_hub_msg = {};

        try {
            obj_hub_msg.str_name = obj_pin.attrs.name;
            obj_hub_msg.str_iccount = obj_pin.attrs.iccount;
            obj_hub_msg.str_all_use_dat_cnt = obj_pin.attrs.all_use_dat_pin_count;

            var ary_child_pin_tag = obj_pin.children;
            var ary_child_pin = [];
            var ui_all_use_dat_cnt = 0;

            for (var idx_pin_child = 0; idx_pin_child < ary_child_pin_tag.length; idx_pin_child++) {
                var obj_child_pin_tag = ary_child_pin_tag[idx_pin_child];
                var ui_use_dat_pin_cnt = Number(obj_child_pin_tag.attrs.use_dat_pin_count);
                var obj_child_pin = {
                    str_subname: obj_child_pin_tag.attrs.subname,
                    str_use_dat_pin_count: ui_use_dat_pin_cnt + "",
                    str_use_ctl_pin_count: obj_child_pin_tag.attrs.use_ctl_pin_count
                };

                ui_all_use_dat_cnt += ui_use_dat_pin_cnt;
                var obj_dat = obj_child_pin_tag.children[0];
                var obj_ctl = obj_child_pin_tag.children[1];
                var ary_dat = [];
                var ary_ctl = [];
                var ui_attrs_idx = 1;
                var str_dat_attr_temp = "pin_";
                var str_ctl_attr_temp = "ctl_";
                var obj_dat_attrs = obj_dat.attrs;
                var obj_ctl_attrs = obj_ctl.attrs;

                while (true) {
                    var str_dat_attrs_val = "";

                    if (obj_dat_attrs) {
                        str_dat_attrs_val = obj_dat_attrs[str_dat_attr_temp + ui_attrs_idx];
                    }
                    var str_ctl_attrs_val = "";

                    if (obj_ctl_attrs) {
                        str_ctl_attrs_val = obj_ctl_attrs[str_ctl_attr_temp + ui_attrs_idx];
                    }

                    if (str_dat_attrs_val) {
                        ary_dat.push(str_dat_attrs_val);
                    }
                    if (str_ctl_attrs_val) {
                        ary_ctl.push(str_ctl_attrs_val);
                    }
                    if (!str_dat_attrs_val && !str_ctl_attrs_val) {
                        break;
                    }
                    ui_attrs_idx++;
                }
                obj_child_pin.ary_st_dat = ary_dat.slice(0, ui_use_dat_pin_cnt);
                obj_child_pin.ary_st_ctl = ary_ctl;
                ary_child_pin.push(obj_child_pin);
            }

            obj_hub_msg.str_all_use_dat_cnt = ui_all_use_dat_cnt + "";
            obj_hub_msg.ary_child_pin = ary_child_pin;
        } catch (error) {
            obj_hub_msg = {};
        }
        m_obj_box.edit_val = obj_hub_msg;
        mc_uibox_dispose_mc_trans_recvcard();
        return true;
    }


    // 处理箱体链接信息
    function mc_uibox_dispose_mc_trans_recvcard() {
        // module_layout 标签内容
        var obj_module_layout = m_obj_box_data.children[MODULE_LAYOUT];
        // 模组列表
        var ary_modlist = obj_module_layout.children;
        var ary_box_mod_data = [];
        var obj_box_trans = m_obj_box_data.children[TRANS].attrs;

        for (var idx_modlist = 0; idx_modlist < ary_modlist.length; idx_modlist++) {
            var str_jx_num = obj_module_layout.children[idx_modlist].attrs.jx_num;
            var ary_jx_mod_list = [];
            var obj_jx_data = {
                jx_num: (Number(str_jx_num) + 1).toString(),
                children: ary_jx_mod_list
            };
            var ary_ledmod = obj_module_layout.children[idx_modlist].children;

            for (var idx_ledmod = 0; idx_ledmod < ary_ledmod.length; idx_ledmod++) {
                var obj_item_attrs = obj_module_layout.children[idx_modlist].children[idx_ledmod].attrs;

                ary_jx_mod_list.push({
                    module_name: obj_item_attrs.guid,
                    offset_x: obj_item_attrs.x,
                    offset_y: obj_item_attrs.y,
                    mirror: obj_item_attrs.mirror || obj_box_trans.mirror,
                    rotation: obj_item_attrs.rotation || obj_box_trans.rotation,
                    scale: obj_item_attrs.scale || obj_box_trans.scale,
                    cut: obj_item_attrs.cut || obj_box_trans.cut
                });
            }
            ary_box_mod_data.push(obj_jx_data);
        }
        m_obj_box.data = ary_box_mod_data;
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    解析导入gamma数据
* 参数:
*    NA
* 返回：
*   @returns {Promise<Boolean>} 解析结果
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2020.6.6
*      内容 : 所有代码
************************************************************************************************/
    function mc_uibox_trans_gamma() {
        var obj_gamma = m_obj_box_data.children[GAMMA];
        var obj_gamma_cfg = m_obj_box_data.children[GAMMA_CFG];
        var obj_gamma_hw = {
            type: obj_gamma.attrs.gamma_mode,
            data: []
        };

        /*         if (obj_gamma.attrs) {
for (var idx_gamma_hw = 0; idx_gamma_hw < obj_gamma.attrs.length; idx_gamma_hw++) {
obj_gamma_hw.data.push(obj_gamma.attrs[idx_gamma_hw].data);
}
} */
        var ary_gamma_val = [];

        for (var idx_gamma_val = 0; idx_gamma_val < obj_gamma_cfg.children.length; idx_gamma_val++) {
            var obj_gamma_val = obj_gamma_cfg.children[idx_gamma_val];
            var obj_data = {
                type: obj_gamma_val.attrs.type ? obj_gamma_val.attrs.type : "",
                appoint_type_name: obj_gamma_val.attrs.appoint_type_name ? obj_gamma_val.attrs.appoint_type_name : "",
                chart_type_name: obj_gamma_val.attrs.chart_type_name ? obj_gamma_val.attrs.chart_type_name : "",
                factor: obj_gamma_val.attrs.factor ? obj_gamma_val.attrs.factor : "",
                gray_bit: obj_gamma_val.attrs.gray_bit ? obj_gamma_val.attrs.gray_bit : "",
                mode_val_idx: obj_gamma_val.attrs.mode_val_idx ? obj_gamma_val.attrs.mode_val_idx : "",
                y_val: obj_gamma_val.attrs.y_val ? obj_gamma_val.attrs.y_val : "",
                data: obj_gamma_val.children[0].data ? obj_gamma_val.children[0].data : "",
                curr_disp_chip: obj_gamma_val.attrs.curr_disp_chip ? obj_gamma_val.attrs.curr_disp_chip : "",
                curr_ctrl_chip: obj_gamma_val.attrs.curr_ctrl_chip ? obj_gamma_val.attrs.curr_ctrl_chip : "",
                box_default_max_val: obj_gamma_val.attrs.box_default_max_val ? obj_gamma_val.attrs.box_default_max_val : ""
            };

            if (!obj_gamma_val.children) {
                continue;
            }
            for (var idx_data = 0; idx_data < obj_gamma_val.children.length; idx_data++) {
                if ("item" === obj_gamma_val.children[idx_data].tagName) {
                    obj_data.data = obj_gamma_val.children[idx_data].data;
                }
            }
            ary_gamma_val.push(obj_data);
        }

        return [obj_gamma_hw, ary_gamma_val];
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    解析导入常规参数
* 参数:
*    NA
* 返回：
*   @returns {Promise<Boolean>} 解析结果
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.6.3
*      内容 : 所有代码
************************************************************************************************/
    function mc_uibox_trans_performance_from_local() {
        var obj_performance = m_obj_box_data.children[PERFORMANCE];

        m_obj_param.set_param_clear();
        var obj_performance_res = obj_performance.attrs;

        for (var key_pamar in obj_performance_res) {
            if (Object.prototype.hasOwnProperty.call(obj_performance_res, key_pamar)) {
                var str_param_name = obj_lang_pamar[key_pamar];
                var str_param_val = obj_performance_res[key_pamar];

                m_obj_param.set_param_value(str_param_name, str_param_val);
            }
        }
        return true;
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    解析导入运行结果
* 参数:
*    NA
* 返回：
*   @returns {Promise<Boolean>} 解析结果
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.6.3
*      内容 : 所有代码
************************************************************************************************/
    function mc_uibox_trans_result_from_local() {
        m_obj_resul.set_param_clear();
        var obj_result = m_obj_box_data.children[RESULT];
        var obj_result_req = obj_result.attrs;

        for (var key_result in obj_result_req) {
            if (Object.prototype.hasOwnProperty.call(obj_result_req, key_result)) {
                var str_param_name = obj_lang_result[key_result];
                var str_param_val = obj_result_req[key_result];

                if ("refresh_freq_list_count" === key_result || "freq_ups_item_count" === key_result || "disp_mode_ary_item_count" === key_result) {
                    var ui_param_val = parseInt(str_param_val, 10);

                    str_param_val = "";
                    var str_dispose_name = "";

                    for (var idx_param = 0; idx_param < ui_param_val; idx_param++) {
                        switch (key_result) {
                        case "refresh_freq_list_count":
                            str_dispose_name = "refresh_freq_item_" + idx_param;
                            break;
                        case "freq_ups_item_count":
                            str_dispose_name = "freq_ups_item_item_" + idx_param;
                            break;
                        case "disp_mode_ary_item_count":
                            str_dispose_name = "disp_mode_ary_item_" + idx_param;
                            break;
                        default:
                            break;
                        }
                        var str_dispose_val = obj_result_req[str_dispose_name];

                        str_param_val += str_dispose_val + ",";
                    }
                    str_param_val = str_param_val.substring(0, str_param_val.length - 1);
                }
                m_obj_resul.set_param_value(str_param_name, str_param_val);
            }
        }
        return true;
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    解析导入接收卡数据
* 参数:
*    NA
* 返回：
*   @returns {Promise<Boolean>} 解析结果
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.6.3
*      内容 : 所有代码
************************************************************************************************/
    function mc_uibox_trans_device_data() {
        m_obj_device_data.set_param_clear();
        if (
            !m_obj_box_data.children ||
            !m_obj_box_data.children[DEVICE_DATA] ||
            !m_obj_box_data.children[DEVICE_DATA].children ||
            !m_obj_box_data.children[DEVICE_DATA].children[0]
        ) {
            return false;
        }
        var obj_device_data = m_obj_box_data.children[DEVICE_DATA];
        var ary_device_item = obj_device_data.children;
        var ary_item_data = ary_device_item[0].children;

        if (!ary_item_data) {
            return true;
        }

        for (var idx_data = 0; idx_data < ary_item_data.length; idx_data++) {
            var obj_item_data = ary_item_data[idx_data];
            var str_param_name = idx_data + "";
            var str_param_val = obj_item_data.data;
            var str_attrs_name = "ADDRESS";
            var str_attrs_val = obj_item_data.attrs.data_addr;

            if (4 > str_param_name.length) {
                var ui_add_zero = 4 - str_param_name.length;

                str_param_name = "";

                for (var idx_name = 0; idx_name < ui_add_zero; idx_name++) {
                    str_param_name += "0";
                }
            }
            str_param_name += idx_data + "";
            m_obj_device_data.set_param_value(str_param_name, str_param_val);
            m_obj_device_data.set_attr_val(str_param_name, str_attrs_name, str_attrs_val);
        }
        return true;
    }

    /************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    解析导入页面相关数据
* 参数:
*    NA
* 返回：
*   NA
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.10.30
*      内容 : 所有代码
************************************************************************************************/
    function mc_uibox_trans_ui_msg() {
        var obj_restore_data = m_obj_box_data.children[RESTORE];
        var obj_correct_data = m_obj_box_data.children[CORRECT];

        var str_restore_value = obj_restore_data.data;

        if ("string" === typeof str_restore_value && 0 < str_restore_value.length) {
            m_str_restore = str_restore_value;
        }
        var obj_correct_msg = obj_correct_data.attrs;

        if (obj_correct_msg) {
            var str_correct_switch_value = obj_correct_msg.correct_switch;

            if ("1" === str_correct_switch_value) {
                m_obj_correct_msg.b_gamut_switch = true;
            }
            var ui_param_idx = 1;

            while (9 >= ui_param_idx) {
                var str_param_name = "correct_param_" + ui_param_idx;

                if (obj_correct_msg[str_param_name]) {
                    m_obj_correct_msg.arr_tbl_data[ui_param_idx - 1] = obj_correct_msg[str_param_name];
                }
                ui_param_idx++;
            }
        }
    }

    /************************************************************************************************
* 类型:
*    函数
* 功能:
*  解析导入模组信息
* 参数:
*    @param {promises<number>} ui_module_id 下标
* 返回：
*   @returns {Promise<Boolean>} 解析结果
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2019.11.21
*      内容 : 所有代码
************************************************************************************************/
    function mc_uibox_trans_module_from_local(ui_module_id) {
        var obj_module_data = m_obj_box_data.children[MODULE_DATA];
        var obj_sdk_module = new mc_sdk_module();

        var ary_mdoule_data = obj_module_data.children;
        var ui_scan_row_count = 0;
        var obj_module_data_item = {};
        var obj_module_val = {};

        obj_module_val.module_name = ary_mdoule_data[ui_module_id].attrs.guid;
        obj_module_data_item = ary_mdoule_data[ui_module_id];

        var ary_modoule_cird = obj_module_data_item.children;

        for (var idx_module_data = 0; idx_module_data < ary_modoule_cird.length; idx_module_data++) {
            if ("basic_info" === ary_modoule_cird[idx_module_data].tagName) {
                var obj_mod_msg = ary_modoule_cird[idx_module_data].attrs;

                ui_scan_row_count = parseInt(obj_mod_msg.scan_row_count, 10);
                obj_sdk_module.mc_util_mod_set_scan_cnt(ui_scan_row_count);
                obj_sdk_module.mc_util_mod_set_disp_chip(obj_mod_msg.driveric);
                obj_sdk_module.mc_util_mod_set_scan_chip(obj_mod_msg.scanic);
                obj_sdk_module.mc_util_mod_set_width(Number(obj_mod_msg.w));
                obj_sdk_module.mc_util_mod_set_height(Number(obj_mod_msg.h));

                var str_pix_step = "1";
                var str_ic_channels = obj_mod_msg.ic_channel_count;
                var str_jump_ic = obj_mod_msg.jump_ic;

                if ("0" !== obj_mod_msg.jump_ic) {
                    str_pix_step = str_ic_channels;
                }
                obj_sdk_module.mc_util_mod_set_scan_pix_step(str_pix_step);
                obj_sdk_module.mc_util_mod_set_jump_ic(str_jump_ic);
                obj_sdk_module.mc_util_mod_set_ic_channels(str_ic_channels);

                var str_clk_type = obj_mod_msg.clk_type;

                obj_sdk_module.mc_util_mod_set_sclk_pin_name(0, "sclk");
                switch (str_clk_type) {
                case "1":
                    obj_sdk_module.mc_util_mod_set_sclk_pin_name(1, "D");
                    break;
                case "2":
                    obj_sdk_module.mc_util_mod_set_sclk_pin_name(1, "E");
                    break;
                case "3":
                    obj_sdk_module.mc_util_mod_set_sclk_pin_name(1, "F");
                    break;
                default:
                    break;
                }
                var str_clk_reple = obj_mod_msg.clk_type_reple;

                if ("string" === typeof str_clk_reple && 0 < str_clk_reple.length && "0" !== str_clk_reple) {
                    var ary_clk_reple = str_clk_reple.split(",");

                    for (var idx_clk = 0; idx_clk < ary_clk_reple.length; idx_clk++) {
                        var ui_clk_cnt = obj_sdk_module.mc_util_mod_get_sclk_pin_cnt();
                        var str_clk_value = ary_clk_reple[idx_clk];

                        obj_sdk_module.mc_util_mod_set_sclk_pin_name(ui_clk_cnt, str_clk_value);
                    }
                }


                var ui_grop_mod = parseInt(obj_mod_msg.group_type, 10);

                ui_grop_mod = (ui_grop_mod >> 20) & 0xF;
                var str_grop_mod = "";

                switch (ui_grop_mod) {
                case 0x1:
                    str_grop_mod = "3";
                    break;
                case 0x2:
                    str_grop_mod = "4";
                    break;
                case 0x4:
                    str_grop_mod = "1";
                    break;
                default:
                    break;
                }
                obj_sdk_module.mc_util_mod_set_str_grp_mode(str_grop_mod);
                // 存入串行类型
                var ui_combo_mod = parseInt(obj_mod_msg.group_type, 10) & 0xFFFF;
                var ui_sclk_cnt = Number(obj_sdk_module.mc_util_mod_get_sclk_pin_cnt());

                obj_sdk_module.mc_util_mod_set_led_type((ui_combo_mod / ui_sclk_cnt));

                var b_lovw_valid = obj_mod_msg.oe_low_valid;

                b_lovw_valid = parseInt(b_lovw_valid, 10);
                obj_sdk_module.mc_util_mod_set_oe_low_valid(b_lovw_valid);
                b_lovw_valid = obj_mod_msg.close_low_valid;
                b_lovw_valid = parseInt(b_lovw_valid, 10);
                obj_sdk_module.mc_util_mod_set_close_low_valid(b_lovw_valid);
                b_lovw_valid = obj_mod_msg.tx_low_valid;
                b_lovw_valid = parseInt(b_lovw_valid, 10);
                obj_sdk_module.mc_util_mod_set_tx_low_valid(b_lovw_valid);

                var ary_clr_val = [];
                var ui_clr_cnt = Number(str_grop_mod);

                if (1 === ui_clr_cnt) {
                    ui_clr_cnt = 3;
                }
                for (var idx_clr = 0; idx_clr < ui_clr_cnt; idx_clr++) {
                    var str_clr_val = obj_mod_msg["group_str_type_" + (idx_clr + 1)];

                    switch (str_clr_val) {
                    case "0":
                        str_clr_val = "R";
                        break;
                    case "1":
                        str_clr_val = "G";
                        break;
                    case "2":
                        str_clr_val = "B";
                        break;
                    default:
                        str_clr_val = "V";
                        break;
                    }
                    ary_clr_val.push(str_clr_val);
                }
                obj_sdk_module.mc_util_mod_set_clr_msg(ary_clr_val);
            } else if ("str_data" === ary_modoule_cird[idx_module_data].tagName) {
                mc_uibox_dispose_module(obj_sdk_module, ary_modoule_cird, idx_module_data, ui_scan_row_count);
            }
        }
        obj_module_val.module_value = obj_sdk_module;
        m_ary_mod_list.push(obj_module_val);
        return true;
    }
    // 处理模组信息
    function mc_uibox_dispose_module(obj_sdk_module, ary_modoule_cird, idx_module_data, ui_scan_row_count) {
        var ary_module_str = ary_modoule_cird[idx_module_data].children;

        for (var idx_module_str = 0; idx_module_str < ary_module_str.length; idx_module_str++) {
            var str_pin_val = ary_module_str[idx_module_str].attrs.pin_id;

            if ("string" !== typeof str_pin_val || 0 >= str_pin_val.length) {
                str_pin_val = "STR_" + idx_module_str;
            }
            obj_sdk_module.mc_util_mod_set_str_name(idx_module_str, str_pin_val);
            obj_sdk_module.mc_util_mod_set_str_pin(idx_module_str, str_pin_val);
            var ary_module_str_item = ary_module_str[idx_module_str].children;
            var ui_str_cnt = parseInt(ary_module_str[idx_module_str].attrs.count, 10);
            var ui_scan_row_scope = ui_str_cnt / ui_scan_row_count;
            var ui_add_val = 0;
            var ui_count = -1;

            for (var idx_str_item = 0; idx_str_item < ary_module_str_item.length; idx_str_item++) {
                var obj_str_item = ary_module_str_item[idx_str_item];
                var str_color = "";

                ui_count++;
                if (ui_count === ui_scan_row_scope) {
                    ui_count = 0;
                    ui_add_val++;
                }

                switch (obj_str_item.attrs.c) {
                case "0":
                    str_color = "R";
                    break;
                case "1":
                    str_color = "G";
                    break;
                case "2":
                    str_color = "B";
                    break;
                case "3":
                    str_color = "V";
                    break;
                default:
                    break;
                }
                obj_sdk_module.mc_util_mod_set_pix_info(idx_module_str, ui_add_val, ui_count, Number(obj_str_item.attrs.x), Number(obj_str_item.attrs.y), str_color);
            }
        }
    }
    /************************************************************************************************
* 类型:
*    函数
* 功能:
*   解析已知箱体信息 生成ui_box_xml字串
* 参数:
*    NA
* 返回：
*   @returns {Promise<String>} ui_box识别xml字串
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2019.11.21
*      内容 : 所有代码
************************************************************************************************/
    function mc_get_box_xml() {
        var str_ctrlchip_name = m_obj_box.ctrlchip_name;
        var str_hub_name = m_obj_box.hub_name;
        var ary_box_size = [m_ui_box_w, m_ui_box_h];
        var obj_box_data = new mc_box_data();

        // box标签
        var obj_uibox_val = obj_box_data.query_object("box");

        obj_uibox_val.attrs.version = "1.0";
        obj_uibox_val.attrs.chip_type_name = str_ctrlchip_name;

        // basic标签
        var str_box_name = "MC_" + str_ctrlchip_name + "_" + str_hub_name;
        var str_first_mod_name = m_ary_mod_list[0].module_name;
        var obj_fist_mod = m_ary_mod_list[0].module_value;

        str_box_name = str_box_name.toUpperCase();
        var obj_basic = {
            "tagName": "basic",
            "attrs": {
                "name": str_box_name,
                "w": ary_box_size[0],
                "h": ary_box_size[1],
                "driveric": obj_fist_mod.mc_util_mod_get_disp_chip(),
                "scanic": obj_fist_mod.mc_util_mod_get_scan_chip(),
                "scan_count": obj_fist_mod.mc_util_mod_get_max_scan_cnt(),
                "data_group_count": Number(obj_fist_mod.mc_util_mod_get_str_cnt()) / Number(obj_fist_mod.mc_util_mod_get_str_grp_mode()),
                "moudle_count": m_ary_mod_list.length,
                "module_name": str_first_mod_name,
                "scan_order": "0"
            }
        };

        obj_uibox_val.children[BASIC] = obj_basic;

        // performance标签
        var obj_performance = mc_get_param_by_items();

        // result标签
        var obj_result = mc_get_result_by_items();

        // basic_reg 标签
        var obj_basic_reg = {
            "tagName": "basic_reg",
            "data": m_obj_disp_reg.get_json()
        };

        // advance_reg 标签
        var obj_advance_reg = {
            "tagName": "advance_reg",
            "data": m_obj_disp_reg_list.get_json()
        };

        // basic_scan_reg 标签
        var obj_basic_scan_reg = {
            "tagName": "basic_scan_reg",
            "data": m_obj_scan_reg.get_json()
        };

        // advance_scan_reg 标签
        var obj_advance_scan_reg = {
            "tagName": "advance_scan_reg",
            "data": m_obj_scan_reg_list.get_json()
        };

        // [0]pin标签  [1]module_layout标签
        var ary_pin_layout = mc_get_box_by_items();

        // module_data 标签
        var obj_module_data = {
            "tagName": "module_data",
            "attrs": {
                "module_data_count": m_ary_mod_list.length
            },
            "children": []
        };

        // gamma_cfg_date 标签
        var obj_gamma_cfg_date = {
            "tagName": "gamma_cfg",
            "children": [{
                "tagName": "gamma_item",
                "attrs": {
                    "appoint_type_name": m_obj_gamma_cfg.appoint_type_name ? m_obj_gamma_cfg.appoint_type_name : "",
                    "chart_type_name": m_obj_gamma_cfg.chart_type_name ? m_obj_gamma_cfg.chart_type_name : "",
                    "factor": m_obj_gamma_cfg.factor ? m_obj_gamma_cfg.factor : "",
                    "gray_bit": m_obj_gamma_cfg.gray_bit ? m_obj_gamma_cfg.gray_bit : "",
                    "mode_val_idx": m_obj_gamma_cfg.mode_val_idx ? m_obj_gamma_cfg.mode_val_idx : "",
                    "type": m_obj_gamma_cfg.type ? m_obj_gamma_cfg.type : "",
                    "y_val": m_obj_gamma_cfg.y_val ? m_obj_gamma_cfg.y_val : "",
                    "curr_disp_chip": m_obj_gamma_cfg.curr_disp_chip ? m_obj_gamma_cfg.curr_disp_chip : "",
                    "curr_ctrl_chip": m_obj_gamma_cfg.curr_ctrl_chip ? m_obj_gamma_cfg.curr_ctrl_chip : "",
                    "box_default_max_val": m_obj_gamma_cfg.box_default_max_val ? m_obj_gamma_cfg.box_default_max_val : ""
                },
                "children": [{
                    "tagName": "item",
                    "data": m_obj_gamma_cfg.data ? m_obj_gamma_cfg.data : ""
                }]
            }]
        };

        // restore标签
        var obj_restore_data = {
            "tagName": "restore",
            "data": m_str_restore
        };
        var obj_correct_data = {
            "tagName": "correct",
            "attrs": {
                "correct_param_1": m_obj_correct_msg.arr_tbl_data[0],
                "correct_param_2": m_obj_correct_msg.arr_tbl_data[1],
                "correct_param_3": m_obj_correct_msg.arr_tbl_data[2],
                "correct_param_4": m_obj_correct_msg.arr_tbl_data[3],
                "correct_param_5": m_obj_correct_msg.arr_tbl_data[4],
                "correct_param_6": m_obj_correct_msg.arr_tbl_data[5],
                "correct_param_7": m_obj_correct_msg.arr_tbl_data[6],
                "correct_param_8": m_obj_correct_msg.arr_tbl_data[7],
                "correct_param_9": m_obj_correct_msg.arr_tbl_data[8],
                "correct_switch": m_obj_correct_msg.b_gamut_switch ? "1" : "0"
            }
        };


        obj_uibox_val.children[PERFORMANCE] = obj_performance;
        obj_uibox_val.children[RESULT] = obj_result;
        obj_uibox_val.children[BASIC_REG] = obj_basic_reg;
        obj_uibox_val.children[ADVANCE_REG] = obj_advance_reg;
        obj_uibox_val.children[BASIC_SCAN_REG] = obj_basic_scan_reg;
        obj_uibox_val.children[ADVANCE_SCAN_REG] = obj_advance_scan_reg;
        obj_uibox_val.children[PIN] = ary_pin_layout[0];
        obj_uibox_val.children[GAMMA_CFG] = obj_gamma_cfg_date;
        obj_uibox_val.children[MODULE_LAYOUT] = ary_pin_layout[1];
        obj_uibox_val.children[TRANS] = {
            "tagName": "box_trans",
            "attrs": {
                "mirror": m_ary_box_trans[0],
                "rotation": m_ary_box_trans[1],
                "scale": m_ary_box_trans[2],
                "workmode": m_ary_box_trans[3] ? m_ary_box_trans[3] : "0",
                "cut": m_ary_box_trans[4] ? m_ary_box_trans[4] : "0,0,0,0"
            }
        };

        for (var idx_mod = 0; idx_mod < m_ary_mod_list.length; idx_mod++) {
            obj_module_data.children.push(mc_get_mod_by_items(idx_mod, str_box_name, ary_pin_layout[0]));
        }
        obj_uibox_val.children[MODULE_DATA] = obj_module_data;
        obj_uibox_val.children[DEVICE_DATA] = mc_get_device_data(ary_box_size[0], ary_box_size[1]);
        obj_uibox_val.children[RESTORE] = obj_restore_data;
        obj_uibox_val.children[CORRECT] = obj_correct_data;
        return obj_box_data.get_xml_text();
    }

    // 将页面识别字串转换为ui_box识别对象
    function mc_get_param_by_items() {
        var obj_performance = {
            "tagName": "performance",
            "attrs": {}
        };

        for (var key_param in obj_lang_pamar) {
            if (Object.prototype.hasOwnProperty.call(obj_lang_pamar, key_param)) {
                var str_param_name = obj_lang_pamar[key_param];
                var str_param_val = m_obj_param.get_param_value(str_param_name);

                if (!str_param_val) {
                    continue;
                }
                obj_performance.attrs[key_param] = str_param_val;
            }
        }
        return obj_performance;
    }
    // 将运行结果转换为ui_box识别对象
    function mc_get_result_by_items() {
        var obj_result = {
            "tagName": "result",
            "attrs": {}
        };


        for (var key_result in obj_lang_result) {
            if (Object.prototype.hasOwnProperty.call(obj_lang_result, key_result)) {
                var str_param_name = obj_lang_result[key_result];
                var str_param_val = m_obj_resul.get_param_value(str_param_name);

                if (!str_param_val) {
                    continue;
                }
                str_param_name = key_result;
                if ("refresh_freq_list_count" === key_result || "freq_ups_item_count" === key_result || "disp_mode_ary_item_count" === key_result) {
                    var ary_param_val = mc_uibox_splice_str(str_param_val, ",");
                    var str_dispose_name = "";

                    for (var idx_attrs = 0; idx_attrs < ary_param_val.length; idx_attrs++) {
                        switch (key_result) {
                        case "refresh_freq_list_count":
                            str_dispose_name = "refresh_freq_item_" + idx_attrs;
                            break;
                        case "freq_ups_item_count":
                            str_dispose_name = "freq_ups_item_item_" + idx_attrs;
                            break;
                        case "disp_mode_ary_item_count":
                            str_dispose_name = "disp_mode_ary_item_" + idx_attrs;
                            break;
                        default:
                            break;
                        }
                        obj_result.attrs[str_dispose_name] = ary_param_val[idx_attrs];
                    }

                    str_param_val = ary_param_val.length.toString();
                }
                obj_result.attrs[str_param_name] = str_param_val;
            }
        }

        return obj_result;
    }
    // 将箱体链接信息解析为ui_box识别对象
    function mc_get_box_by_items() {
        var obj_pin = {
            "tagName": "pin",
            "attrs": {
                "name": "",
                "iccount": "",
                "all_use_dat_pin_count": ""
            },
            "children": []
        };

        /* set pin tag */
        var obj_hub_msg = m_obj_box.edit_val;

        obj_pin.attrs.name = obj_hub_msg.str_name;
        obj_pin.attrs.iccount = obj_hub_msg.str_iccount;
        obj_pin.attrs.all_use_dat_pin_count = obj_hub_msg.str_all_use_dat_cnt;

        var ary_child_pin_list = obj_hub_msg.ary_child_pin;

        for (var idx_child_pin = 0; idx_child_pin < ary_child_pin_list.length; idx_child_pin++) {
            var obj_child_pin_msg = ary_child_pin_list[idx_child_pin];

            /* set pin-child_pin tag */
            var obj_child_pin = {};

            obj_child_pin.tagName = "child_pin";
            obj_child_pin.attrs = {
                subname: obj_child_pin_msg.str_subname,
                use_dat_pin_count: obj_child_pin_msg.str_use_dat_pin_count,
                use_ctl_pin_count: obj_child_pin_msg.str_use_ctl_pin_count
            };
            obj_child_pin.children = [];

            /* set pin-child_pin-dat tag */
            var obj_dat = {};

            obj_dat.tagName = "dat";
            obj_dat.attrs = {};

            var ary_pin_dat_value = obj_child_pin_msg.ary_st_dat;

            for (var idx_dat = 0; idx_dat < ary_pin_dat_value.length; idx_dat++) {
                var str_dat_name = "pin_" + (idx_dat + 1);

                obj_dat.attrs[str_dat_name] = ary_pin_dat_value[idx_dat];
            }

            obj_child_pin.children.push(obj_dat);

            /* set pin-child_pin-ctl tag */
            var obj_ctl = {};

            obj_ctl.tagName = "ctl";
            obj_ctl.attrs = {};

            var ary_pin_ctl = obj_child_pin_msg.ary_st_ctl;

            for (var idx_ctl = 0; idx_ctl < ary_pin_ctl.length; idx_ctl++) {
                var str_ctl_name = "ctl_" + (idx_ctl + 1);

                obj_ctl.attrs[str_ctl_name] = ary_pin_ctl[idx_ctl];
            }
            obj_child_pin.children.push(obj_ctl);
            obj_pin.children.push(obj_child_pin);
        }

        /* set module_layout tag */
        var obj_module_layout_req = {};

        obj_module_layout_req.tagName = "module_layout";
        obj_module_layout_req.attrs = {};
        obj_module_layout_req.children = [];
        var ary_mod_list = m_obj_box.data;

        for (var idx_modlist = 0; idx_modlist < ary_mod_list.length; idx_modlist++) {
            var obj_jx_moules = {};

            obj_jx_moules.tagName = "jx_modules";
            obj_jx_moules.attrs = {};
            var obj_modlist = ary_mod_list[idx_modlist];

            obj_jx_moules.attrs.jx_num = (Number(obj_modlist.jx_num) - 1).toString();
            var ary_jx_modlist = obj_modlist.children;

            obj_jx_moules.attrs.jx_module_count = ary_jx_modlist.length.toString();
            obj_jx_moules.children = [];
            for (var idx_ledmod = 0; idx_ledmod < ary_jx_modlist.length; idx_ledmod++) {
                var obj_item = ary_jx_modlist[idx_ledmod];

                obj_item.tagName = "item";
                obj_item.attrs = {};
                obj_item.attrs.guid = obj_item.module_name;
                obj_item.attrs.x = obj_item.offset_x;
                obj_item.attrs.y = obj_item.offset_y;
                obj_item.attrs.mirror = obj_item.mirror;
                obj_item.attrs.rotation = obj_item.rotation;
                obj_item.attrs.scale = obj_item.scale;
                obj_item.attrs.cut = obj_item.cut || "0,0,0,0";
                obj_jx_moules.children.push(obj_item);
            }

            obj_module_layout_req.children.push(obj_jx_moules);
        }
        obj_module_layout_req.attrs.jx_count = obj_module_layout_req.children.length.toString();
        var obj_module_layout = obj_module_layout_req;

        return [obj_pin, obj_module_layout];
    }
    // 将模组信息解析为ui_box识别对象
    function mc_get_mod_by_items(ui_mod_idx, str_box_name, obj_pin_tag) {
        var obj_mod_data = m_ary_mod_list[ui_mod_idx];
        var str_module_name = obj_mod_data.module_name;
        var obj_sdk_module = obj_mod_data.module_value;
        var str_mod_jump_ic = obj_sdk_module.mc_util_mod_get_jump_ic();
        var str_mod_ic_channal = obj_sdk_module.mc_util_mod_get_ic_channels();
        var obj_module_val = {};

        obj_module_val.module_name = str_module_name;

        var obj_module_data_item = {};

        obj_module_data_item.tagName = "module_data_item";
        obj_module_data_item.children = [];
        obj_module_data_item.attrs = {};
        obj_module_data_item.attrs.guid = str_module_name;

        var obj_basic_info = {};

        obj_basic_info.tagName = "basic_info";
        obj_basic_info.attrs = {};

        var str_grop_mod = obj_sdk_module.mc_util_mod_get_str_grp_mode();
        var ui_clk_cnt = obj_sdk_module.mc_util_mod_get_sclk_pin_cnt();

        switch (Number(str_grop_mod)) {
        case 1:
            var ui_grop_type = obj_sdk_module.mc_util_mod_get_led_type();


            str_grop_mod = 400000 + (ui_clk_cnt * ui_grop_type) + "";
            break;
        case 3:
            str_grop_mod = "100000";
            break;
        case 4:
            str_grop_mod = "200000";
            break;
        default:
            break;
        }

        // 时钟默认为单路时钟
        var str_clk_type = "0";
        var str_clk_type_reple = "0,";
        // 由于目前只支持双时钟,所以只获取第二路时钟值进行储存
        var str_sclk_val = obj_sdk_module.mc_util_mod_get_sclk_pin_name(1);

        switch (str_sclk_val) {
        case "D":
            str_clk_type = "1";
            break;
        case "E":
            str_clk_type = "2";
            break;
        case "F":
            str_clk_type = "3";
            break;
        default:
            if ("string" === typeof str_sclk_val && 0 < str_sclk_val.length) {
                str_clk_type_reple = str_sclk_val + ",";
            }
            break;
        }

        for (var idx_clk = 2; idx_clk < ui_clk_cnt; idx_clk++) {
            if ("0," === str_clk_type_reple) {
                str_clk_type_reple = "";
            }
            str_clk_type_reple += obj_sdk_module.mc_util_mod_get_sclk_pin_name(idx_clk) + ",";
        }

        obj_basic_info.attrs.name = str_box_name;
        obj_basic_info.attrs.guid = str_module_name;
        obj_basic_info.attrs.group_type = parseInt(str_grop_mod, 16);
        obj_basic_info.attrs.driveric = obj_sdk_module.mc_util_mod_get_disp_chip();
        obj_basic_info.attrs.scanic = obj_sdk_module.mc_util_mod_get_scan_chip();
        obj_basic_info.attrs.scan_row_count = obj_sdk_module.mc_util_mod_get_scan_cnt_loc();
        obj_basic_info.attrs.clk_type = str_clk_type;
        obj_basic_info.attrs.clk_type_reple = str_clk_type_reple.slice(0, -1);
        obj_basic_info.attrs.oe_low_valid = Number(obj_sdk_module.mc_util_mod_get_oe_low_valid()).toString();
        obj_basic_info.attrs.close_low_valid = Number(obj_sdk_module.mc_util_mod_get_close_low_valid()).toString();
        obj_basic_info.attrs.tx_low_valid = Number(obj_sdk_module.mc_util_mod_get_tx_low_valid()).toString();
        obj_basic_info.attrs.jump_ic = str_mod_jump_ic;
        obj_basic_info.attrs.ic_channel_count = str_mod_ic_channal;
        obj_basic_info.attrs.w = obj_sdk_module.mc_util_mod_get_width();
        obj_basic_info.attrs.h = obj_sdk_module.mc_util_mod_get_height();
        obj_basic_info.attrs.str_count = obj_sdk_module.mc_util_mod_get_str_cnt();
        obj_basic_info.attrs.data_group_count = Number(obj_basic_info.attrs.str_count) / Number(obj_sdk_module.mc_util_mod_get_str_grp_mode());

        var obj_str_data = {};

        obj_str_data.tagName = "str_data";
        obj_str_data.children = [];
        var ui_str_cnt = obj_basic_info.attrs.str_count;

        mc_uibox_dispose_set_module(obj_sdk_module, ui_str_cnt, obj_str_data, obj_basic_info, obj_module_data_item, obj_pin_tag);

        return obj_module_data_item;
    }
    // 处理模组信息数据
    function mc_uibox_dispose_set_module(obj_sdk_module, ui_str_cnt, obj_str_data, obj_basic_info, obj_module_data_item, obj_pin_tag) {
        for (var idx_str = 0; idx_str < ui_str_cnt; idx_str++) {
            var obj_strdata_str = {};

            obj_strdata_str.attrs = {};
            obj_strdata_str.tagName = "str";
            obj_strdata_str.attrs.pin_id = obj_sdk_module.mc_util_mod_get_str_pin(idx_str);
            if ("string" !== typeof obj_strdata_str.attrs.pin_id || 0 >= obj_strdata_str.attrs.pin_id.length) {
                obj_strdata_str.attrs.pin_id = "STR_" + idx_str;
            }
            obj_strdata_str.children = [];
            var ui_scan_cnt = obj_sdk_module.mc_util_mod_get_scan_cnt(idx_str);

            for (var idx_scan = 0; idx_scan < ui_scan_cnt; idx_scan++) {
                var ui_pix_cnt = obj_sdk_module.mc_util_mod_get_pix_cnt(idx_str, idx_scan);

                for (var idx_pix = 0; idx_pix < ui_pix_cnt; idx_pix++) {
                    var obj_strdata_item = {};

                    obj_strdata_item.attrs = {};
                    obj_strdata_item.tagName = "item";
                    var obj_pix_val = obj_sdk_module.mc_util_mod_get_pix_info(idx_str, idx_scan, idx_pix);

                    obj_strdata_item.attrs.x = obj_pix_val.u32_img_x.toString();
                    obj_strdata_item.attrs.y = obj_pix_val.u32_img_y.toString();

                    var str_color = "";

                    switch (obj_pix_val.c_color) {
                    case "R":
                        str_color = "0";
                        break;
                    case "G":
                        str_color = "1";
                        break;
                    case "B":
                        str_color = "2";
                        break;
                    case "V":
                        str_color = "3";
                        break;
                    default:
                        break;
                    }


                    obj_strdata_item.attrs.c = str_color;
                    obj_strdata_str.children.push(obj_strdata_item);
                }
            }
            obj_strdata_str.attrs.count = obj_strdata_str.children.length.toString();
            obj_str_data.children.push(obj_strdata_str);
        }
        var ary_clr_val = obj_sdk_module.mc_util_mod_get_clr_msg();

        for (var idx_group = 0; 4 > idx_group; idx_group++) {
            var str_group_name = "group_str_type_" + (idx_group + 1);
            var str_group_val = ary_clr_val[idx_group];

            switch (str_group_val) {
            case "R":
                str_group_val = "0";
                break;
            case "G":
                str_group_val = "1";
                break;
            case "B":
                str_group_val = "2";
                break;
            default:
                str_group_val = "3";
                break;
            }
            obj_basic_info.attrs[str_group_name] = str_group_val;
        }
        obj_module_data_item.children.push(obj_basic_info);
        obj_module_data_item.children.push({
            tagName: "pin_data",
            attrs: {
                name: obj_pin_tag.attrs.name,
                iccount: obj_pin_tag.attrs.iccount,
                all_use_dat_pin_count: obj_pin_tag.attrs.all_use_dat_pin_count
            },
            children: obj_pin_tag.children
        });
        obj_module_data_item.children.push(obj_str_data);
    }
    // 将接收卡数据解析为ui_box识别对象
    function mc_get_device_data(ui_box_w, ui_box_h) {
        var ui_param_cnt = m_obj_device_data.get_param_cnt();

        if (!ui_param_cnt) {
            return {
                "tagName": "device_data"
            };
        }
        var obj_item_data = {
            "tagName": "device_data_item",
            "attrs": {
                "count": "",
                "ic_idx": "0",
                "ic_offset_x": "0",
                "ic_offset_y": "0",
                "ic_size_w": (ui_box_w + ""),
                "ic_size_h": (ui_box_h + "")
            },
            "children": []
        };

        for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
            var str_param_name = m_obj_device_data.get_param_name(idx_param);
            var str_param_val = m_obj_device_data.get_param_value(str_param_name);
            var str_address_val = m_obj_device_data.get_attr_val(str_param_name, "ADDRESS");
            var str_data_len = Number(str_param_val.length / 2).toString(16);

            if (8 > str_data_len.length) {
                var ui_add_zero = 8 - str_data_len.length;

                for (var idx_zero = 0; idx_zero < ui_add_zero; idx_zero++) {
                    str_data_len = "0" + str_data_len;
                }
            }
            var obj_data = {
                "tagName": "data",
                "attrs": {
                    "data_len": str_data_len,
                    "data_addr": str_address_val
                },
                "data": str_param_val
            };

            obj_item_data.children.push(obj_data);
        }
        obj_item_data.attrs.count = ui_param_cnt;
        var obj_device_data = {
            "tagName": "device_data",
            "attrs": {
                "ic_use_count": "1"
            },
            "children": [obj_item_data]
        };

        return obj_device_data;
    }

    /************************************************************************************************
* 类型:
*   函数
* 功能:
*   数据矫正
* 参数:
*    NA
* 返回：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.12.10
*      内容 : 所有代码
************************************************************************************************/
    function mc_data_check() {
        mc_data_check_box();
    }
    /************************************************************************************************
* 类型:
*   函数
* 功能:
*   数据矫正-箱体
* 参数:
*    NA
* 返回：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.12.10
*      内容 : 所有代码
************************************************************************************************/
    function mc_data_check_box() {
        // 获取箱体引脚数量
        var ary_mod_list = m_obj_box.data;

        for (var idx_modlist_cnt = 0; idx_modlist_cnt < ary_mod_list.length; idx_modlist_cnt++) {
            var obj_item = ary_mod_list[idx_modlist_cnt];
            // 获取引脚下箱体数量
            var ary_jx_modlist = obj_item.children;

            for (var idx_mod_cnt = 0; idx_mod_cnt < ary_jx_modlist.length; idx_mod_cnt++) {
                var obj_mod_offset = ary_jx_modlist[idx_mod_cnt];

                var ary_chek_val = [obj_mod_offset.mirror, obj_mod_offset.rotation, obj_mod_offset.scale,obj_mod_offset.cut || "0,0,0,0"];
                var ary_chek_list = [mc_check_mirror, mc_check_rotation, mc_check_scale];
                var b_is_updata = false;

                for (var idx_check = 0; idx_check < ary_chek_list.length; idx_check++) {
                    var mc_check_fn = ary_chek_list[idx_check];
                    var str_updata_val = mc_check_fn(ary_chek_val[idx_check]);

                    if (!str_updata_val) {
                        continue;
                    }
                    b_is_updata = true;
                    ary_chek_val[idx_check] = str_updata_val;
                }
                if (!b_is_updata) {
                    continue;
                }
            }
        }
    }
    /**
* 校验镜像表达式
* @param {String} str_mirror 镜像表达式
* @returns {String} 校验结果,空表示校验成功
*/
    function mc_check_mirror(str_mirror) {
        str_mirror = !str_mirror ? "" : str_mirror;
        var ary_mirror_list = str_mirror.split(",");

        if (1 === ary_mirror_list.length) {
            str_mirror = "";
        } else if (1 > ary_mirror_list.length) {
            str_mirror = ary_mirror_list[0];
        } else {
            str_mirror = "0";
        }
        return str_mirror;
    }
    /**
* 校验旋转表达式
* @param {String} str_rotation 旋转表达式
* @returns {String} 校验结果,空表示校验成功
*/
    function mc_check_rotation(str_rotation) {
        str_rotation = !str_rotation ? "" : str_rotation;
        var ary_rotation = str_rotation.split(",");

        if (1 === ary_rotation.length) {
            str_rotation = "0,0," + str_rotation;
        } else if (3 === ary_rotation.length) {
            str_rotation = "";
        } else {
            str_rotation = "0,0,0";
        }
        return str_rotation;
    }
    /**
* 校验缩放表达式
* @param {String} str_scale 缩放表达式
* @returns {String} 校验结果,空表示校验成功
*/
    function mc_check_scale(str_scale) {
        str_scale = !str_scale ? "" : str_scale;
        var ary_scale = str_scale.split(",");

        if (1 === ary_scale.length) {
            str_scale = "0.0,0.0," + ary_scale[0] + "," + ary_scale[0];
        } else if (2 === ary_scale.length) {
            str_scale = "0.0,0.0," + ary_scale[0] + "," + ary_scale[1];
        } else if (3 === ary_scale.length) {
            str_scale = ary_scale[0] + "," + ary_scale[1] + "," + ary_scale[3] + "," + ary_scale[3];
        } else if (4 === ary_scale.length) {
            str_scale = "";
        } else {
            str_scale = "0.0,0.0,1.0,1.0";
        }
        return str_scale;
    }
}

